% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{pathling_filter}
\alias{pathling_filter}
\title{Filter a DataFrame using a FHIRPath or search expression}
\usage{
pathling_filter(df, pc, resource_type, expression, type = "fhirpath")
}
\arguments{
\item{df}{A \code{tbl_spark} containing FHIR resource data.}

\item{pc}{The PathlingContext object.}

\item{resource_type}{A string containing the FHIR resource type code (e.g., "Patient",
"Observation").}

\item{expression}{The filter expression. For \code{type = "fhirpath"}, a FHIRPath boolean
expression (e.g., "gender = 'male'"). For \code{type = "search"}, a FHIR search query string
(e.g., "gender=male&birthdate=ge1990-01-01").}

\item{type}{The type of expression: \code{"fhirpath"} (default) or \code{"search"}.}
}
\value{
A \code{tbl_spark} containing only the rows matching the expression.
}
\description{
Filters a \code{tbl_spark} using either a FHIRPath boolean expression or a FHIR search query
string, returning a \code{tbl_spark} containing only the matching rows. The DataFrame must be the
first argument to enable piping with \code{\%>\%}.
}
\examples{
\dontrun{
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))
patients <- data_source \%>\% ds_read("Patient")

# Filter using a FHIRPath expression.
male_patients <- patients \%>\%
  pathling_filter(pc, "Patient", "gender = 'male'")

# Filter using a FHIR search expression.
male_patients <- patients \%>\%
  pathling_filter(pc, "Patient", "gender=male", type = "search")

pathling_disconnect(pc)
}
}
\seealso{
Other context functions: 
\code{\link{pathling_fhirpath_to_column}()},
\code{\link{pathling_search_to_column}()},
\code{\link{pathling_with_column}()}
}
\concept{context functions}
