% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_reg_flexsurvspline.R
\name{details_survival_reg_flexsurvspline}
\alias{details_survival_reg_flexsurvspline}
\title{Flexible parametric survival regression}
\description{
\code{\link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline()}} fits a flexible parametric survival model.
}
\details{
For this engine, there is a single mode: censored regression
\subsection{Tuning Parameters}{

This model has one engine-specific tuning parameter:
\itemize{
\item \code{k}: Number of knots in the spline. The default is \code{k = 0}.
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

survival_reg() |> 
  set_engine("flexsurvspline") |> 
  set_mode("censored regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Parametric Survival Regression Model Specification (censored regression)
## 
## Computational engine: flexsurvspline 
## 
## Model fit template:
## flexsurv::flexsurvspline(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg())
}\if{html}{\out{</div>}}
}

\subsection{Other details}{

The main interface for this model uses the formula method since the
model specification typically involved the use of
\code{\link[survival:Surv]{survival::Surv()}}.

For this engine, stratification cannot be specified via
\code{\link[survival:strata]{survival::strata()}}, please see
\code{\link[flexsurv:flexsurvspline]{flexsurv::flexsurvspline()}} for
alternative specifications.

Predictions of type \code{"time"} are predictions of the mean survival time.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("survival_reg_predict") |>
  dplyr::filter(engine == "flexsurvspline") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 5 x 2
##   mode                type       
##   <chr>               <chr>      
## 1 censored regression time       
## 2 censored regression quantile   
## 3 censored regression hazard     
## 4 censored regression survival   
## 5 censored regression linear_pred
}\if{html}{\out{</div>}}
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{References}{
\itemize{
\item Jackson, C. 2016. \code{flexsurv}: A Platform for Parametric Survival
Modeling in R. \emph{Journal of Statistical Software}, 70(8), 1 - 33.
}
}
}
\keyword{internal}
