% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{Zero Code Instrumentation}
\alias{Zero Code Instrumentation}
\title{Zero Code Instrumentation}
\value{
Not applicable.
}
\description{
otel supports zero-code instrumentation (ZCI) via the
\code{OTEL_INSTRUMENT_R_PKGS} environment variable. Set this to a comma
separated list of package names, the packages that you want to
instrument. Then otel will hook up \code{\link[base:trace]{base::trace()}} to produce
OpenTelemetry output from every function of these packages.
}
\details{
By default all functions of the listed packages are instrumented. To
instrument a subset of all functions set the
\verb{OTEL_INSTRUMENT_R_PKGS_<PKG>_INCLUDE} environment variable to a list of
glob expressions. \verb{<PKG>} is the package name in all capital letters.
Only functions that match to at least one glob expression will be
instrumented.

To exclude functions from instrumentation, set the
\verb{OTEL_INSTRUMENT_R_PKGS_<PKG>_EXCLUDE} environment variable to a list of
glob expressions. \verb{<PKG>} is the package name in all capital letters.
Functions that match to at least one glob expression will not be
instrumented. Inclusion globs are applied before exclusion globs.
\subsection{Caveats}{

If the user calls \code{\link[base:trace]{base::trace()}} on an instrumented function, that
deletes the instrumentation, since the second \code{\link[base:trace]{base::trace()}} call
overwrites the first.
}
}
\examples{
# To run an R script with ZCI:
# OTEL_TRACES_EXPORTER=http OTEL_INSTRUMENT_R_PKGS=dplyr,tidyr R -q -f script.R
}
\seealso{
\link{Environment Variables}

Other OpenTelemetry trace API: 
\code{\link{end_span}()},
\code{\link{is_tracing_enabled}()},
\code{\link{local_active_span}()},
\code{\link{start_local_active_span}()},
\code{\link{start_span}()},
\code{\link{tracing-constants}},
\code{\link{with_active_span}()}
}
\concept{OpenTelemetry trace API}
