% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_plot}
\alias{wb_add_plot}
\title{Insert the current plot into a worksheet}
\usage{
wb_add_plot(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  width = 6,
  height = 4,
  row_offset = 0,
  col_offset = 0,
  file_type = "png",
  units = "in",
  dpi = 300,
  ...
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{dims}{Worksheet dimension, single cell ("A1") or cell range ("A1:D4")}

\item{width}{Width of figure. Defaults to \code{6} in.}

\item{height}{Height of figure . Defaults to \code{4} in.}

\item{row_offset, col_offset}{Offset for column and row}

\item{file_type}{File type of image}

\item{units}{Units of width and height. Can be \code{"in"}, \code{"cm"} or \code{"px"}}

\item{dpi}{Image resolution}

\item{...}{additional arguments}
}
\description{
The current plot is saved to a temporary image file using
\code{\link[grDevices:dev2]{grDevices::dev.copy()}} This file is then written to the workbook using
\code{\link[=wb_add_image]{wb_add_image()}}.
}
\examples{
if (requireNamespace("ggplot2") && interactive()) {
## Create a new workbook
wb <- wb_workbook()

## Add a worksheet
wb$add_worksheet("Sheet 1", grid_lines = FALSE)

## create plot objects
require(ggplot2)
p1 <- ggplot(mtcars, aes(x = mpg, fill = as.factor(gear))) +
  ggtitle("Distribution of Gas Mileage") +
  geom_density(alpha = 0.5)
p2 <- ggplot(Orange, aes(x = age, y = circumference, color = Tree)) +
  geom_point() + geom_line()

## Insert currently displayed plot to sheet 1, row 1, column 1
print(p1) # plot needs to be showing
wb$add_plot(1, width = 5, height = 3.5, file_type = "png", units = "in")

## Insert plot 2
print(p2)
wb$add_plot(1, dims = "J2", width = 16, height = 10, file_type = "png", units = "cm")

}
}
\seealso{
\code{\link[=wb_add_chart_xml]{wb_add_chart_xml()}} \code{\link[=wb_add_drawing]{wb_add_drawing()}} \code{\link[=wb_add_image]{wb_add_image()}} \code{\link[=wb_add_mschart]{wb_add_mschart()}}
}
