% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_bookview}
\alias{wb_set_bookview}
\alias{wb_get_bookview}
\alias{wb_remove_bookview}
\title{Get and Set the workbook position, size and filter}
\usage{
wb_get_bookview(wb)

wb_remove_bookview(wb, view = NULL)

wb_set_bookview(
  wb,
  active_tab = NULL,
  auto_filter_date_grouping = NULL,
  first_sheet = NULL,
  minimized = NULL,
  show_horizontal_scroll = NULL,
  show_sheet_tabs = NULL,
  show_vertical_scroll = NULL,
  tab_ratio = NULL,
  visibility = NULL,
  window_height = NULL,
  window_width = NULL,
  x_window = NULL,
  y_window = NULL,
  view = 1L,
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object}

\item{view}{Which view to modify. Default is \code{1} (the first view).}

\item{active_tab}{activeTab}

\item{auto_filter_date_grouping}{autoFilterDateGrouping}

\item{first_sheet}{The first sheet to be displayed}

\item{minimized}{minimized}

\item{show_horizontal_scroll}{showHorizontalScroll}

\item{show_sheet_tabs}{showSheetTabs}

\item{show_vertical_scroll}{showVerticalScroll}

\item{tab_ratio}{tabRatio}

\item{visibility}{visibility}

\item{window_height}{windowHeight}

\item{window_width}{windowWidth}

\item{x_window}{xWindow}

\item{y_window}{yWindow}

\item{...}{additional arguments}
}
\value{
A data frame with the bookview properties

The Workbook object

The Workbook object
}
\description{
Get and Set the workbook position, size and filter
}
\examples{
 wb <- wb_workbook()
 wb <- wb_add_worksheet(wb)

 # set the first and second bookview (horizontal split)
 wb <- wb_set_bookview(wb,
     window_height = 17600, window_width = 15120,
     x_window = 15120, y_window = 760)
 wb <- wb_set_bookview(wb,
     window_height = 17600, window_width = 15040,
     x_window = 0, y_window = 760, view = 2
   )

 wb_get_bookview(wb)

 # remove the first view
 wb <- wb_remove_bookview(wb, view = 1)
 wb_get_bookview(wb)

 # keep only the first view
 wb <- wb_remove_bookview(wb, view = -1)
 wb_get_bookview(wb)
}
