% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockDeath.R
\name{mockDeath}
\alias{mockDeath}
\title{Generates a mock death table and integrates it into an existing CDM object.}
\usage{
mockDeath(cdm, recordPerson = 1, seed = NULL)
}
\arguments{
\item{cdm}{A `cdm_reference` object that must already include 'person' and
'observation_period' tables.This object is the base CDM structure
where the death data will be added. It is essential that the
'person' and 'observation_period' tables are populated as they
provide necessary context for generating death records.}

\item{recordPerson}{An integer specifying the expected number of death
records to generate per person. This parameter helps
simulate varying frequencies of death occurrences among
individuals in the cohort, reflecting the variability
seen in real-world medical data. Typically, this would
be set to 1 or 0, assuming most datasets would only
record a single death date per individual if at all.}

\item{seed}{An optional integer used to set the seed for random number
generation, ensuring reproducibility of the generated data. If
provided, it allows the function to produce the same results
each time it is run with the same inputs. If 'NULL', the seed is
not set, which can result in different outputs on each run.}
}
\value{
Returns the modified `cdm` object with the new 'death' table added.
        This table includes the simulated death data for each person,
        ensuring that each record is linked correctly to individuals in the '
        person' table and falls within valid observation periods.
}
\description{
This function simulates death records for individuals within a specified
cohort. It creates a realistic dataset by generating death records according
to the specified number of records per person. The function ensures that each
death record is associated with a valid person within the observation period
to maintain the integrity of the data.
}
\examples{
\donttest{
library(omock)

# Create a mock CDM reference and add death records
cdm <- mockCdmReference() |>
  mockPerson() |>
  mockObservationPeriod() |>
  mockDeath(recordPerson = 1)

# View the generated death data
print(cdm$death)
}
}
