% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.1.111m.R
\name{od.1.111m}
\alias{od.1.111m}
\title{Jointly optimal sample allocation identification for single-level
    randomized controlled trials (RCTs) investigating
    main and moderation effects (1-1-1m)}
\usage{
od.1.111m(
  d = NULL,
  gamma = NULL,
  n = NULL,
  Q = 0.5,
  p = NULL,
  binary = TRUE,
  c1 = NULL,
  c1t = NULL,
  r12 = NULL,
  r.yx = 0,
  r.mx = 0,
  r.ym = 0,
  m = NULL,
  q.main = 1,
  q.mod = 1,
  power.mod = 0.8,
  power.main = 0.8,
  d.p = c(0.1, 0.5),
  sig.level = 0.05,
  two.tailed = TRUE,
  verbose = TRUE,
  nlim = c(20, 1e+07),
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 50,
  q = 1e-04,
  xi = 0.5
)
}
\arguments{
\item{d}{The standardized main effect size.}

\item{gamma}{Moderated treatment effect.}

\item{n}{Total number of individuals.}

\item{Q}{The proportion of individuals in one group the binary moderator.
Default value is 0.5, which requires the minimum number of individuals
to achieve a targeted power. Change it as necessary.}

\item{p}{The proportion of individuals assigned to the experimental group.}

\item{binary}{Logical. The moderator is binary if TRUE and continuous if
FALSE. Default is TRUE.}

\item{c1}{The cost of sampling one unit in control condition.}

\item{c1t}{The cost of sampling one unit in treatment condition.}

\item{r12}{The proportion of within-treatment outcome variance explained
by covariates in the model that estimated the main effect.}

\item{r.yx}{Within-treatment correlation between the outcome (y) and
the covariate (x) for continuous moderators. Within-treatment
within-moderator correlation between the outcome (y) and
the covariate (x) for binary moderators.}

\item{r.mx}{Within-treatment correlation between the moderator (m) and
the covariate (x), if specified, for continuous moderators.}

\item{r.ym}{Within-treatment correlation between the outcome (y) and
the moderator (m), if specified, for continuous moderators.}

\item{m}{Total budget.}

\item{q.main}{The number of covariates in the model estimating the main
effect (besides the treatment, moderator). The default value is 1.}

\item{q.mod}{The number of covariates in the moderation model (besides the
treatment, moderator, and their interaction term). The default value is 1.}

\item{power.mod}{Statistical power specified for the moderation effect.
The default value is .80.}

\item{power.main}{Statistical power specified for the main effect.
The default value is .80.}

\item{d.p}{The initial sampling domains for p. Default is c(0.10, 0.50).}

\item{sig.level}{Significance level, default value is .05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{verbose}{Print out evaluation process if TRUE. The default value is TRUE.}

\item{nlim}{The range for identifying the root of sample size (\code{n})
numerically. Default is c(20, 1e7).}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is infinite.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion. The default value is 300.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion. The default value is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after
the initialization stage. The default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 20.}

\item{q}{Locality of the search (0,1). The default value is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1).
The default value is 0.5.}
}
\value{
Unconstrained or constrained optimal sample allocation \code{p}).
    The function also returns statistical power for
    main and moderation effects,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of single-level RCTs
    probing main and moderation effects is to identify the jointly optimal sample
    allocation that use the minimum budget to achieve targeted
    statistical power for both effects. The optimal design parameter
    is the proportion of
    individuals/units assigned to the experimental condition.
    This function uses the ant colony optimization algorithm
    to identify the optimal \code{p}.
}
\examples{
myod <- od.1.111m(d =.1, gamma = .2, r12 = .50,
                 c1 = 10, c1t = 100)
myod
}
