% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.1.R
\name{od.1}
\alias{od.1}
\title{Optimal sample allocation calculation for single-level experiments
detecting main effects}
\usage{
od.1(
  p = NULL,
  r12 = NULL,
  c1 = NULL,
  c1t = NULL,
  m = NULL,
  plots = TRUE,
  plim = NULL,
  varlim = NULL,
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  verbose = TRUE
)
}
\arguments{
\item{p}{The proportion of individuals to be assigned to treatment.}

\item{r12}{The proportion of outcome variance explained by covariates.}

\item{c1}{The cost of sampling one unit in control condition.}

\item{c1t}{The cost of sampling one unit in treatment condition.}

\item{m}{Total budget, default value is the total costs of sampling 60
individuals across treatment conditions.}

\item{plots}{Logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{plab}{The plot label for \code{p} ,
default value is "Proportion of Individuals in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{verbose}{Logical; print the value of \code{p} if TRUE,
otherwise not; default value is TRUE.}
}
\value{
Unconstrained or constrained optimal sample allocation (\code{p}).
    The function also returns the variance of the treatment effect,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of single-level experiments detecting main effects
    is to choose
    the optimal sample allocation that minimizes the variance of
    a treatment effect under a fixed budget,  which is approximately the optimal
    sample allocation that maximizes statistical power under a fixed budget.
    The optimal design parameter is
    the proportion of individuals to be assigned to treatment (\code{p}).
}
\examples{
# Unconstrained optimal design #---------
  myod1 <- od.1(r12 = 0.5, c1 = 1, c1t = 5, varlim = c(0, 0.2))
  myod1$out # output

# Constrained p, no calculation performed #---------
  myod2 <- od.1(r12 = 0.5, c1 = 1, c1t = 5, varlim = c(0, 0.2), p = 0.5)
  myod2$out
# Relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.87

# When sampling costs are equal, a balanced  design with p = 0.5 is the best #---------
  myod3 <- od.1(r12 = 0.5, c1 = 1, c1t = 1, varlim = c(0, 0.2))
  myod3$out # output

}
