% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_npar.R
\name{method_npar}
\alias{method_npar}
\title{Mass imputation using non-parametric model method}
\usage{
method_npar(
  y_nons,
  X_nons,
  X_rand,
  svydesign,
  weights = NULL,
  family_outcome = "gaussian",
  start_outcome = NULL,
  vars_selection = FALSE,
  pop_totals = NULL,
  pop_size = NULL,
  control_outcome = control_out(),
  control_inference = control_inf(),
  verbose = FALSE,
  se = TRUE
)
}
\arguments{
\item{y_nons}{target variable from non-probability sample}

\item{X_nons}{a \code{model.matrix} with auxiliary variables from non-probability sample}

\item{X_rand}{a \code{model.matrix} with auxiliary variables from non-probability sample}

\item{svydesign}{a svydesign object}

\item{weights}{case / frequency weights from non-probability sample (default NULL)}

\item{family_outcome}{family for the glm model)}

\item{start_outcome}{a place holder (not used in \code{method_npar})}

\item{vars_selection}{whether variable selection should be conducted}

\item{pop_totals}{a place holder (not used in \code{method_npar})}

\item{pop_size}{population size from the \code{nonprob} function}

\item{control_outcome}{controls passed by the \code{control_out} function}

\item{control_inference}{controls passed by the \code{control_inf} function}

\item{verbose}{parameter passed from the main \code{nonprob} function}

\item{se}{whether standard errors should be calculated}
}
\value{
an \code{nonprob_method} class which is a \code{list} with the following entries

\describe{
\item{model_fitted}{fitted model object returned by \code{stats::loess}}
\item{y_nons_pred}{predicted values for the non-probablity sample}
\item{y_rand_pred}{predicted values for the probability sample or population totals}
\item{coefficients}{coefficients for the model (if available)}
\item{svydesign}{an updated \code{surveydesign2} object (new column \code{y_hat_MI} is added)}
\item{y_mi_hat}{estimated population mean for the target variable}
\item{vars_selection}{whether variable selection was performed}
\item{var_prob}{variance for the probability sample component (if available)}
\item{var_nonprob}{variance for the non-probability sampl component}
\item{model}{model type (character \code{"npar"})}
}
}
\description{
Model for the outcome for the mass imputation estimator using loess via \code{stats::loess}.
Estimation of the mean is done using the \eqn{S_B} probability sample.
}
\details{
Analytical variance

The variance of the mean is estimated based on the following approach

(a) non-probability part  (\eqn{S_A} with size \eqn{n_A}; denoted as \code{var_nonprob} in the result)

\deqn{
\hat{V}_1 = \frac{1}{N^2} \sum_{i=1}^{n_A} \left\lbrace\hat{g}_B(\boldsymbol{x}_i)\right\rbrace^{2} \hat{e}_i^2,
}

where \eqn{\hat{e}_i=y_i - \hat{m}(x_i)} is the residual and \eqn{\hat{g}_B(\boldsymbol{x}_i) = \left\lbrace \pi_B(\boldsymbol{x}_i) \right\rbrace^{-1}} can be estimated
various ways. In the package we estimate \eqn{\hat{g}_B(\boldsymbol{x}_i)} using \eqn{\pi_B(\boldsymbol{x}_i)=E(R | \boldsymbol{x})} as suggested by Chen et al. (2022, p. 6). In particular,
we currently support this using stats::loess\code{with}"gaussian"` family.

(b) probability part (\eqn{S_B} with size \eqn{n_B}; denoted as \code{var_prob} in the result)

This part uses functionalities of the \code{{survey}} package and the variance is estimated using the following
equation:

\deqn{
\hat{V}_2=\frac{1}{N^2} \sum_{i=1}^{n_B} \sum_{j=1}^{n_B} \frac{\pi_{i j}-\pi_i \pi_j}{\pi_{i j}}
\frac{\hat{m}(x_i)}{\pi_i} \frac{\hat{m}(x_j)}{\pi_j}.
}

Note that \eqn{\hat{V}_2} in principle can be estimated in various ways depending on the type of the design and whether population size is known or not.
}
\examples{

set.seed(123123123)
N <- 10000
n_a <- 500
n_b <- 1000
n_b1 <- 0.7*n_b
n_b2 <- 0.3*n_b
x1 <- rnorm(N, 2, 1)
x2 <- rnorm(N, 2, 1)
y1 <- rnorm(N, 0.3 + 2*x1+ 2*x2, 1)
y2 <- rnorm(N, 0.3 + 0.5*x1^2+ 0.5*x2^2, 1)
strata <- x1 <= 2
pop <- data.frame(x1, x2, y1, y2, strata)
sample_a <- pop[sample(1:N, n_a),]
sample_a$w_a <- N/n_a
sample_a_svy <- svydesign(ids=~1, weights=~w_a, data=sample_a)
pop1 <- subset(pop, strata == TRUE)
pop2 <- subset(pop, strata == FALSE)
sample_b <- rbind(pop1[sample(1:nrow(pop1), n_b1), ],
                  pop2[sample(1:nrow(pop2), n_b2), ])
res_y_npar <- nonprob(outcome = y1 + y2 ~ x1 + x2,
                      data = sample_b,
                      svydesign = sample_a_svy,
                      method_outcome = "npar")
res_y_npar

}
\references{
Chen, S., Yang, S., & Kim, J. K. (2022). Nonparametric mass imputation for data integration.
Journal of Survey Statistics and Methodology, 10(1), 1-24.
}
