% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_geography}
\alias{aggregate_geography}
\title{Aggregate Data by Geography Level}
\usage{
aggregate_geography(data, to_type, value_col = "OBS_VALUE", fun = sum)
}
\arguments{
\item{data}{Data frame with geography codes}

\item{to_type}{Target geography TYPE code}

\item{value_col}{Column containing values to aggregate (default: "OBS_VALUE")}

\item{fun}{Aggregation function (default: sum)}
}
\value{
A tibble with aggregated data grouped by specified variables.
}
\description{
Aggregates data to higher geography levels.
}
\examples{
data(jsa_sample)
aggregated <- aggregate_geography(jsa_sample, "TYPE499", "OBS_VALUE")
head(aggregated)
}
