% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmeU-package.R
\docType{data}
\name{prt.subjects}
\alias{prt.subjects}
\title{prt.subjects Data (63 x 5)}
\format{
A data frame with 63 rows and 5 columns:
\describe{
  \item{id}{A factor with 63 levels: \code{5}, \code{10}, \code{15}, \code{20}, \code{25}, ...}
  \item{prt.f}{A factor with 2 levels: \code{High}, \code{Low}}
  \item{age.f}{A factor with 2 levels: \code{Young}, \code{Old}}
  \item{sex.f}{A factor with 2 levels: \code{Female}, \code{Male}}
  \item{bmi}{A numeric vector with values from 18.4 to 32.3}
}
}
\source{
Claflin, D.R., Larkin, L.M., Cederna, P.S., Horowitz, J.F.,
  Alexander, N.B., Cole, N.M., Galecki, A.T., Chen, S., Nyquist, L.V., Carlson,
  B.M., Faulkner, J.A., & Ashton-Miller, J.A. (2011). Effects of high- and
  low-velocity resistance training on the contractile properties of skeletal
  muscle fibers from young and older humans. Journal of Applied Physiology, 111, 1021-1030.
}
\usage{
prt.subjects
}
\description{
Data from a Progressive Resistance Randomized Trial.
}
\details{
The working hypothesis was that a 12-week program of PRT would increase:
(a) the power output of the overall musculature associated with movements of the ankles, knees, and hips;
(b) the cross-sectional area and the force and power of permeabilized single fibers obtained from the vastus lateralis muscle; and
(c) the ability of young and elderly men and women to safely arrest standardized falls. The training consisted of repeated leg extensions by
shortening contractions of the leg extensor muscles against a resistance that was increased as the subject trained using a specially designed apparatus.
}
\examples{
data(prt.subjects, package = "nlmeU")
summary(prt.subjects)
}
\keyword{datasets}
