% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leanify.R
\name{leanify_r6}
\alias{leanify_r6}
\alias{leanify_package}
\title{Move all methods of an R6 Class to an environment}
\usage{
leanify_r6(cls, env = cls$parent_env)

leanify_package(pkg_env = parent.frame(), skip_if = function(x) FALSE)
}
\arguments{
\item{cls}{(\link[R6:R6Class]{R6::R6Class})\cr
Class generator to modify.}

\item{env}{(\code{environment})\cr
The target environment where the function should be stored.
This should be either \code{cls$parent_env} (default) or one of its
parent environments, otherwise the stump function will not find the moved
(original code) function.}

\item{pkg_env}{:: \code{environment}\cr
The namespace from which to leanify all R6 classes. Does not have to be a
package namespace, but this is the intended usecase.}

\item{skip_if}{:: \code{function}\cr
Function with one argument: Is called for each individual \code{\link[R6:R6Class]{R6::R6Class}}.
If it returns \code{TRUE}, the class is skipped. Default function evaluating to \code{FALSE}
always (i.e. skipping no classes).}
}
\value{
\code{NULL}.
}
\description{
\code{leanify_r6} moves the content of an \code{\link[R6:R6Class]{R6::R6Class}}'s functions to an environment,
usually the package's namespace, to save space during serialization of R6 objects.
\code{leanify_package} move all methods of \emph{all} R6 Classes to an environment.

The function in the class (i.e. the object generator) is replaced by a stump
function that does nothing except calling the original function that now resides
somewhere else.

It is possible to call this function after the definition of an \link[R6:R6Class]{R6::R6}
class inside a package, but it is preferred to use \code{\link[=leanify_package]{leanify_package()}}
to just leanify all \link[R6:R6Class]{R6::R6} classes inside a package.
}
