% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{host_url}
\alias{host_url}
\alias{local_url}
\title{URL Constructors}
\usage{
host_url(tls = FALSE, port = 0)

local_url(tcp = FALSE, port = 0)
}
\arguments{
\item{tls}{[default FALSE] logical value whether to use TLS in which case
the scheme used will be 'tls+tcp://'.}

\item{port}{[default 0] numeric port to use. \code{0} is a wildcard value that
automatically assigns a free ephemeral port. For \code{host_url}, this port
should be open to connections from the network addresses the daemons are
connecting from. For \code{local_url}, is only taken into account if
\code{tcp = TRUE}.}

\item{tcp}{[default FALSE] logical value whether to use a TCP connection.
This must be used for SSH tunnelling.}
}
\value{
A character vector (comprising a valid URL or URLs), named for
\code{host_url()}.
}
\description{
\code{host_url()} constructs a valid host URL (at which daemons may connect) based
on the computer's IP address. This may be supplied directly to the \code{url}
argument of \code{\link[=daemons]{daemons()}}.

\code{local_url()} constructs a URL suitable for local daemons, or for use with
SSH tunnelling. This may be supplied directly to the \code{url} argument of
\code{\link[=daemons]{daemons()}}.
}
\details{
\code{host_url()} will return a vector of URLs if multiple network adapters are in
use, and each will be named by the interface name (adapter friendly name on
Windows). If this entire vector is passed to the \code{url} argument of functions
such as \code{daemons()}, the first URL is used. If no suitable IP addresses are
detected, the computer's hostname will be used as a fallback.

\code{local_url()} generates a random URL for the platform's default inter-process
communications transport: abstract Unix domain sockets on Linux, Unix domain
sockets on MacOS, Solaris and other POSIX platforms, and named pipes on
Windows.
}
\examples{
host_url()
host_url(tls = TRUE)
host_url(tls = TRUE, port = 5555)

local_url()
local_url(tcp = TRUE)
local_url(tcp = TRUE, port = 5555)

}
