# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic functionality for data.frame conversion
test_that("convert_nest converts basic nested structures to data.frame", {
  # Create test data
  nested_dt <- data.table(
    id = 1:2,
    nested = list(
      data.table(x = 1:3, y = letters[1:3]),
      data.table(x = 4:6, y = letters[4:6])
    )
  )
  
  # Convert to data.frame
  result <- convert_nest(nested_dt, to = "df")
  
  # Check overall structure
  expect_true(inherits(result, "tbl_df"))
  expect_false(inherits(result, "data.table"))
  
  # Check nested elements
  expect_true(all(sapply(result$nested, inherits, "tbl_df")))
  expect_false(any(sapply(result$nested, inherits, "data.table")))
})

# Test basic functionality for data.table conversion
test_that("convert_nest converts basic nested structures to data.table", {
  # Create test data
  nested_df <- tibble::tibble(
    id = 1:2,
    nested = list(
      tibble::tibble(x = 1:3, y = letters[1:3]),
      tibble::tibble(x = 4:6, y = letters[4:6])
    )
  )
  
  # Convert to data.table
  result <- convert_nest(nested_df, to = "dt")
  
  # Check overall structure
  expect_true(inherits(result, "data.table"))
  
  # Check nested elements
  expect_true(all(sapply(result$nested, inherits, "data.table")))
})

# Test automatic nested column detection
test_that("convert_nest automatically detects nested columns", {
  # Create test data with multiple nested columns
  test_data <- data.table(
    id = 1:2,
    nested1 = list(data.table(a = 1), data.table(a = 2)),
    normal = 1:2,
    nested2 = list(data.table(b = 1), data.table(b = 2))
  )
  
  result <- convert_nest(test_data, to = "df")
  
  # Check that both nested columns were converted
  expect_true(all(sapply(result$nested1, inherits, "tbl_df")))
  expect_true(all(sapply(result$nested2, inherits, "tbl_df")))
  expect_true(is.numeric(result$normal))  # Non-nested column should remain unchanged
})

# Test specified nested columns
test_that("convert_nest handles specified nested columns", {
  test_data <- data.table(
    id = 1:2,
    nested1 = list(data.table(a = 1), data.table(a = 2)),
    nested2 = list(data.table(b = 1), data.table(b = 2))
  )
  
  # Only convert nested1
  result <- convert_nest(test_data, to = "df", nest_cols = "nested1")
  
  expect_true(all(sapply(result$nested1, inherits, "tbl_df")))
  expect_true(all(sapply(result$nested2, inherits, "data.table")))
})

# Test handling of empty nested columns
test_that("convert_nest handles empty nested columns", {
  test_data <- data.table(
    id = 1:2,
    nested = list(data.table(), data.table())
  )
  
  result <- convert_nest(test_data, to = "df")
  
  expect_true(all(sapply(result$nested, inherits, "tbl_df")))
  expect_true(all(sapply(result$nested, nrow) == 0))
})

# Test data copying
test_that("convert_nest creates copies and doesn't modify original data", {
  # Create test data
  original_dt <- data.table(
    id = 1:2,
    nested = list(
      data.table(x = 1:3),
      data.table(x = 4:6)
    )
  )
  
  # Make a copy for comparison
  original_copy <- copy(original_dt)
  
  # Convert to data.frame
  result <- convert_nest(original_dt, to = "df")
  
  # Check that original data wasn't modified
  expect_equal(original_dt, original_copy)
})

# Test error handling x
test_that("convert_nest handles invalid inputs appropriately", {
  nested_dt <- data.table(
    id = 1:2,
    nested = list(
      data.table(x = 1:3, y = letters[1:3]),
      data.table(x = 4:6, y = letters[4:6])
    )
  )
  
  # Test invalid 'to' parameter
  expect_error(
    convert_nest(nested_dt, to = "invalid"),
    "should be one of"
  )
  
  # Test invalid nest_cols
  expect_error(
    convert_nest(nested_dt, to = "df", nest_cols = "nonexistent"),
    "Column\\(s\\) not found in data: nonexistent"
  )
})

