% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfm_nystrom.R
\name{kfm_nystrom}
\alias{kfm_nystrom}
\alias{kfm_nystrom.default}
\alias{kfm_nystrom.mild_df}
\title{Fit a Nyström kernel feature map approximation}
\usage{
kfm_nystrom(df, m, r, kernel, sampling, ...)

\method{kfm_nystrom}{default}(
  df,
  m = nrow(df),
  r = m,
  kernel = "radial",
  sampling = "random",
  ...
)

\method{kfm_nystrom}{mild_df}(
  df,
  m = nrow(df),
  r = m,
  kernel = "radial",
  sampling = "random",
  ...
)
}
\arguments{
\item{df}{An object containing covariates for training.  Usually a data.frame
or matrix.}

\item{m}{The number of examples from \code{df} to sample in fitting.}

\item{r}{The rank of matrix approximation to use. Must be less than or equal
to \code{m}, the default.}

\item{kernel}{A character determining the kernel to use.  Currently, only
\code{'radial'} is implemented.}

\item{sampling}{A character determining how to sample instances.  Default is
\code{'random'}. For \code{kfm_nystrom.mild_df()}, one can specify \code{sampling = 'stratified'} to ensure that samples are chosen evenly from bags and
instances. \code{sampling} can also be a numeric vector of length \code{m} of
pre-determined samples.}

\item{...}{additional parameters needed for the kernels.  See details.}
}
\value{
an object of class \code{kfm_nystrom} with the following components:
\itemize{
\item \code{df_sub} the sub-sampled version of \code{df}
\item \code{dv} pre-multiplication matrix which contains information on the
eigenvalues and eigenvectors of \code{df_sub}
\item \code{method} \code{'nystrom'}
\item \code{kernel} the input parameter \code{kernel}
\item \code{kernel_params} parameters passed to \code{...}
}
}
\description{
Use the Nyström method to fit a feature map that approximates a given kernel.
}
\details{
For the \code{...} argument, the additional parameters depend on which kernel is
used:
\itemize{
\item For \code{kernel = 'radial'}, specify \code{sigma} to define kernel bandwidth.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: For use on objects of class \code{data.frame} or \code{matrix}.

\item \code{mild_df}: Ignore the information columns \code{'bag_label'},
\code{'bag_name'}, and \code{'instance_name'} when calculating kernel approximation.
}}

\examples{
df <- data.frame(
  X1 = c(2,   3,   4,   5,   6, 7, 8),
  X2 = c(1, 1.2, 1.3, 1.4, 1.1, 7, 1),
  X3 = rnorm(7)
)

fit <- kfm_nystrom(df, m = 7, r = 6, kernel = "radial", sigma = 0.05)
fm <- build_fm(fit, df)

}
\references{
Williams, C., & Seeger, M. (2001). Using the Nyström Method to
Speed Up Kernel Machines. \emph{Advances in Neural Information Processing
Systems}, \emph{13}, 682–688.

Kent, S., & Yu, M. (2022). Non-convex SVM for cancer diagnosis based on
morphologic features of tumor microenvironment \emph{arXiv preprint}
\href{https://arxiv.org/abs/2206.14704}{arXiv:2206.14704}
}
\seealso{
Other kernel feature map functions: 
\code{\link{kfm_exact}()}
}
\author{
Sean Kent
}
\concept{kernel feature map functions}
