% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval-cumoddsreg.r
\name{interval.logitsurv.discrete}
\alias{interval.logitsurv.discrete}
\alias{Interval}
\alias{dInterval}
\alias{simlogitSurvd}
\alias{predictlogitSurvd}
\alias{cumoddsreg}
\alias{simTTP}
\alias{predictSurvd}
\alias{plotSurvd}
\title{Discrete time to event interval censored data}
\usage{
interval.logitsurv.discrete(
  formula,
  data,
  beta = NULL,
  no.opt = FALSE,
  method = "NR",
  stderr = TRUE,
  weights = NULL,
  offsets = NULL,
  exp.link = 1,
  increment = 1,
  ...
)
}
\arguments{
\item{formula}{formula}

\item{data}{data}

\item{beta}{starting values}

\item{no.opt}{optimization TRUE/FALSE}

\item{method}{NR, nlm}

\item{stderr}{to return only estimate}

\item{weights}{weights following id for GLM}

\item{offsets}{following id  for GLM}

\item{exp.link}{parametrize increments exp(alpha) > 0}

\item{increment}{using increments dG(t)=exp(alpha) as parameters}

\item{...}{Additional arguments to lower level funtions lava::NR  optimizer or nlm}
}
\description{
We consider the cumulative odds model 
\deqn{
   P(T \leq t | x) =  \frac{G(t) \exp(x \beta) }{1 + G(t) exp( x \beta) }
}
or equivalently 
\deqn{
   logit(P(T \leq t | x)) = log(G(t)) + x \beta
}
and we can thus also compute the probability of surviving 
\deqn{
   P(T >t | x) =  \frac{1}{1 + G(t) exp( x \beta) }
}
}
\details{
The baseline \eqn{G(t)} is written as \eqn{cumsum(exp(\alpha))} and this is not the standard
parametrization that takes log of \eqn{G(t)} as the parameters. Note that the regression 
coefficients are describing the probability of dying before or at time t. 

Input are intervals given by ]t_l,t_r] where t_r can be infinity for right-censored intervals 
When truly discrete ]0,1] will be an observation at 1, and  ]j,j+1] will be an observation at j+1.
Can be used for fitting the usual ordinal regression model (with logit link) that in contrast, however, 
describes the probibility of surviving time t (thus leads to -beta).

Likelihood is maximized:
\deqn{
 \prod  P(T_i >t_{il} | x) - P(T_i> t_{ir}| x) 
}
}
\examples{
library(mets)
data(ttpd) 
dtable(ttpd,~entry+time2)

out <- interval.logitsurv.discrete(Interval(entry,time2)~X1+X2+X3+X4,ttpd)
summary(out)
head(iid(out)) 

pred <- predictlogitSurvd(out,se=FALSE)
plotSurvd(pred)

ttpd <- dfactor(ttpd,fentry~entry)
out <- cumoddsreg(fentry~X1+X2+X3+X4,ttpd)
summary(out)
head(iid(out)) 

}
\author{
Thomas Scheike
}
