% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{aspwb_day_inner}
\alias{aspwb_day_inner}
\alias{communication}
\alias{copy_model_output}
\alias{general_communication_structures}
\alias{instance_communication_structures}
\alias{growth_day_inner}
\alias{spwb_day_inner}
\title{Internal communication}
\usage{
aspwb_day_inner(
  internalCommunication,
  x,
  date,
  meteovec,
  latitude,
  elevation,
  slope = NA_real_,
  aspect = NA_real_,
  runon = 0,
  lateralFlows = NULL,
  waterTableDepth = NA_real_,
  modifyInput = TRUE
)

copy_model_output(internalCommunication, x, model)

general_communication_structures(
  numCohorts,
  nlayers,
  ncanlayers,
  ntimesteps,
  model
)

instance_communication_structures(x, model)

growth_day_inner(
  internalCommunication,
  x,
  date,
  meteovec,
  latitude,
  elevation,
  slope = NA_real_,
  aspect = NA_real_,
  runon = 0,
  lateralFlows = NULL,
  waterTableDepth = NA_real_,
  modifyInput = TRUE
)

spwb_day_inner(
  internalCommunication,
  x,
  date,
  meteovec,
  latitude,
  elevation,
  slope = NA_real_,
  aspect = NA_real_,
  runon = 0,
  lateralFlows = NULL,
  waterTableDepth = NA_real_,
  modifyInput = TRUE
)
}
\arguments{
\item{internalCommunication}{List for internal communication.}

\item{x}{An object of class \code{\link{spwbInput}} or \code{\link{growthInput}}.}

\item{date}{Date as string "yyyy-mm-dd".}

\item{meteovec}{A named numerical vector with weather data. See variable names in parameter \code{meteo} of \code{\link{spwb}}.}

\item{latitude}{Latitude (in degrees).}

\item{elevation, slope, aspect}{Elevation above sea level (in m), slope (in degrees) and aspect (in degrees from North).}

\item{runon}{Surface water amount running on the target area from upslope (in mm).}

\item{lateralFlows}{Lateral source/sink terms for each soil layer (interflow/to from adjacent locations) as mm/day.}

\item{waterTableDepth}{Water table depth (in mm). When not missing, capillarity rise will be allowed if lower than total soil depth.}

\item{modifyInput}{Boolean flag to indicate that the input \code{x} object is allowed to be modified during the simulation.}

\item{model}{String for model, either "spwb" or "growth".}
}
\description{
Functions for internal communication. Not to be called by users.
}
\keyword{internal}
