% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{n_chains-n_draws-n_vars}
\alias{n_chains-n_draws-n_vars}
\alias{n_chains}
\alias{n_draws}
\alias{n_vars}
\title{Get the number of chains, samples per chain or the number of variables in a simulation object}
\usage{
n_chains(obj)

n_draws(obj)

n_vars(dc)
}
\arguments{
\item{obj}{an mcdraws object or a draws component (dc) object.}

\item{dc}{a draws component object.}
}
\value{
The number of chains or retained samples per chain or
 the number of variables.
}
\description{
Get the number of chains, samples per chain or the number of variables in a simulation object
}
\examples{
\donttest{
ex <- mcmcsae_example(n=50)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=5, store.all=TRUE)
n_chains(sim); n_chains(sim$beta)
n_draws(sim); n_draws(sim$beta)
n_vars(sim$beta); n_vars(sim$sigma_); n_vars(sim$llh_); n_vars(sim$v)
plot(sim, "beta")
n_chains(subset(sim$beta, chains=1:2))
n_draws(subset(sim$beta, draws=sample(1:n_draws(sim), 100)))
n_vars(subset(sim$u, vars=1:2))
}

}
