% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{contrast}
\alias{contrast}
\title{Contrast Profile Computation}
\usage{
contrast(
  negative_data,
  positive_data,
  window_size,
  positive_matrix = NULL,
  exclusion_zone = 0.5,
  distance = c("euclidean", "pearson"),
  n_workers = 1L,
  progress = TRUE
)
}
\arguments{
\item{negative_data}{Required. Any 1-dimension series of numbers (\code{matrix}, \code{vector}, \code{ts} etc.) where the pattern is not present}

\item{positive_data}{Required. Any 1-dimension series of numbers (\code{matrix}, \code{vector}, \code{ts} etc.) where the pattern is present}

\item{window_size}{Required. An integer defining the rolling window size.}

\item{positive_matrix}{Optional. A precomputed self-similar matrix profile of the positive data.}

\item{exclusion_zone}{A numeric. Defines the size of the area around the rolling window that will be ignored to avoid
trivial matches. Default is \code{0.5}, i.e., half of the \code{window_size}.}

\item{distance}{A string. Currently accepts \code{euclidean} and \code{pearson}. Defaults to \code{euclidean}.}

\item{n_workers}{An integer. The number of threads using for computing. Defaults to \code{1}.}

\item{progress}{A logical. If \code{TRUE} (the default) will show a progress bar. Useful for long computations.}
}
\value{
Returns a \code{list} with the \code{contrast_profile}, \code{plato}, \code{plato_nn}, \code{plato_idx}, \code{plato_nn_idx}, \code{w}, \code{ez}, \code{euclidean}
values
}
\description{
Computes the contrast profile of two (classes of) time series.
}
\details{
\subsection{Constrast Profile}{

This algorithm returns the contrast profile of two time series, which shows the position of patters that are similar in the
positive data, but at the same time very dissimilar in the negative data.  In other words, this means that such a pattern
represents well positive data and may be taken as a "signature" of that class. More information can be found in the references.
}
}
\examples{
cp <- contrast(motifs_discords_small, rev(motifs_discords_small), 50)

}
\references{
\itemize{
\item R. Mercer, S. Alaee, A. Abdoli, S. Singh, A. Murillo and E. Keogh, "Matrix Profile XXIII: Contrast Profile:
A Novel Time Series Primitive that Allows Real World Classification," 2021 IEEE International Conference on Data Mining (ICDM), 2021,
pp. 1240-1245, doi: 10.1109/ICDM51629.2021.00151.
}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
