% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{classify_zones}
\alias{classify_zones}
\title{Classify Coordinates into Focus, Glue, or Context Zones}
\usage{
classify_zones(coords, cx = 0, cy = 0, r_in = 0.34, r_out = 0.5)
}
\arguments{
\item{coords}{A numeric matrix or data frame with at least two
columns representing \verb{(x, y)} coordinates.}

\item{cx, cy}{Numeric. The x and y coordinates of the fisheye
center (default = 0, 0).}

\item{r_in}{Numeric. Inner radius of the focus zone
(default = 0.34).}

\item{r_out}{Numeric. Outer radius of the glue zone
(default = 0.5).}
}
\value{
A character vector of the same length as \code{nrow(coords)},
with values \code{"focus"}, \code{"glue"}, or \code{"context"}.
}
\description{
Assigns each point to one of three zones based on its radial
distance from a specified center:
\itemize{
\item \strong{focus}: inside the inner radius \code{r_in}
\item \strong{glue}: between \code{r_in} and \code{r_out}
\item \strong{context}: outside \code{r_out}
}

This is a helper for visualizing and analyzing fisheye
transformations using the Focus–Glue–Context (FGC) model.
}
\examples{
# Simple example
pts <- matrix(c(0, 0, 0.2, 0.2, 0.6, 0.6), ncol = 2, byrow = TRUE)
classify_zones(pts, r_in = 0.3, r_out = 0.5)
#> "focus"   "glue"    "context"

}
\seealso{
\code{\link[=fisheye_fgc]{fisheye_fgc()}}, \code{\link[=plot_fisheye_fgc]{plot_fisheye_fgc()}}
}
