% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{get_kennedy_estimator}
\alias{get_kennedy_estimator}
\title{Kennedy Estimator}
\usage{
get_kennedy_estimator(coefficient, variance)
}
\arguments{
\item{coefficient}{numeric value of the estimated coefficient for a dummy
variable in a semi-logarithmic regression}

\item{variance}{numeric value of the variance of this estimated coefficient}
}
\value{
a numeric value representing the so-called "Kennedy estimator"
}
\description{
Computes the consistent and almost unbiased estimator for dummy variables in
semi-logarithmic regressions proposed by Kennedy, P.E. (1981). Estimation
with correctly interpreted dummy variables in semi-logarithmic equations.
American Economic Review, 71, 801.
}
\details{
Given a semi-logarithmic regression with a dummy variable and its estimated
coefficient \code{c} with a variance \code{v}, the consistent and almost
unbiased estimator proposed by Kennedy is computed as
\code{k = exp(c) / exp(v / 2) - 1}
}
\keyword{internal}
