% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendry-package.R
\name{common_parameters}
\alias{common_parameters}
\title{common parameters in \pkg{legendry}}
\arguments{
\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{available_aes}{A \verb{<character>} vector listing the aesthetics for which this guide can
be build.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{override.aes}{A named \verb{<list>} specifying aesthetic parameters of the
key glyphs. See details and examples in
\code{\link[ggplot2:guide_legend]{guide_legend()}}.}
}
\description{
This is a collection of common parameters so they needn't be re-documented
each time.
}
\keyword{internal}
