% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{dbConnect,SFSQLDriver-method}
\alias{dbConnect,SFSQLDriver-method}
\title{dbConnect}
\usage{
\S4method{dbConnect}{SFSQLDriver}(drv, DSN = "", readonly = TRUE, ...)
}
\arguments{
\item{drv}{SFSQLDriver created by \code{SFSQL()}}

\item{DSN}{data source name, may be a file, or folder path, database connection string, or URL}

\item{readonly}{open in readonly mode (\code{TRUE} is the only option)}

\item{...}{ignored}
}
\description{
dbConnect for drawings that may be read by package sf
}
\details{
The 'OGRSQL' available is documented with GDAL: https://gdal.org/user/ogr_sql_dialect.html
}
\examples{
afile <- system.file("gpkg/nc.gpkg", package = "sf", mustWork = TRUE)
db <- dbConnect(SFSQL(), afile)
dbSendQuery(db, 'SELECT * FROM "nc.gpkg"')
}
