% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{set_style}
\alias{set_style}
\title{Set a new style by list}
\usage{
set_style(style_name, style_entry)
}
\arguments{
\item{style_name}{[chr] name of the style to set}

\item{style_entry}{[list] named list representing the style entry}
}
\value{
[chr] invisible vector of input objects, to allow easier un-locking
}
\description{
Set a new style by list
}
\examples{
set_style(
   style_name    = "my_style"
   , style_entry = list(
      prop_digits_round     = 2
      , count_digits_sigfig = 3
      , count_method        = "sigfig"
      , count_pad_sigfigs   = TRUE
      , prop_nsmall         = 1
      , count_nsmall        = 1
      , decimal.mark        = "."
      , neg_mark_UI         = "-"
      , count_big.mark      = ","
      , neg_mark_mean       = "a decrease of"
      , UI_only             = FALSE
      , UI_text             = ""
      , assert_clu_order    = TRUE
      , is_lancet           = FALSE
      , label_thousands     = FALSE
      , round_5_up          = TRUE
   )
)
}
\seealso{
Other styles: 
\code{\link{assert_style_schema}()},
\code{\link{get_style}()},
\code{\link{get_style_schema}()},
\code{\link{new_style}()},
\code{\link{style_lancet}()},
\code{\link{style_nature}()}
}
\concept{styles}
