% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vectors.R
\name{fround_clu_triplet}
\alias{fround_clu_triplet}
\title{Format and round central/lower/upper value sets by magnitude without units.}
\usage{
fround_clu_triplet(
  clu,
  d_type,
  style_name = "nature",
  df_mag = set_magnitude(clu[1])
)
}
\arguments{
\item{clu}{[num] a numeric triplet of three values in central/lower/upper
order.}

\item{d_type}{[chr c('prop', 'pp', or 'count')] data type - proportion,
percentage point or count}

\item{style_name}{[chr: default 'nature'] style name - controls rounding and
formatting.}

\item{df_mag}{[named list] output from `set_magnitude()` - must be based on
central value of a central/lower/upper set - central and all UI values
inherit the same scale as the central tendency.}
}
\value{
[chr] formatted string (vectorized)
}
\description{
`central` could be mean/median/point_estimate. `d_type` is required (count
data requires nuanced logic), but labels are not returned.
}
\details{
Format and round without unit labeling
- Use `format_lancet_clu()` for unit labels
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_journal_df}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_means_df}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
\keyword{internal}
