% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.R
\name{jaccard.ev}
\alias{jaccard.ev}
\title{Compute an expected Jaccard/Tanimoto similarity coefficient under independence}
\usage{
jaccard.ev(x, y, px = NULL, py = NULL)
}
\arguments{
\item{x}{a binary vector (e.g., fingerprint)}

\item{y}{a binary vector (e.g., fingerprint)}

\item{px}{probability of successes in \code{x} (optional)}

\item{py}{probability of successes in \code{y} (optional)}
}
\value{
\code{jaccard.ev} returns an expected value.
}
\description{
Compute an expected Jaccard/Tanimoto similarity coefficient under independence
}
\examples{
set.seed(1234)
x = rbinom(100,1,.5)
y = rbinom(100,1,.5)
jaccard.ev(x,y)
}
