% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_projection-simulation.R
\name{project}
\alias{project}
\title{Calculate the trajectories of a network model}
\usage{
project(
  nm,
  dt = NULL,
  grid_size = NULL,
  at = NULL,
  end = NULL,
  flows = "no",
  cached_ts = NULL,
  cached_ee = NULL,
  ignore_pulses = FALSE
)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{dt, grid_size}{Either the time step size for trajectory calculations
(\code{dt}) or the number of points for the calculation (\code{grid_size})
can be provided. If none is provided, then a default grid size of 256 steps
is used.}

\item{at}{Optional, vector of time values at which the trajectory must be
evaluated.}

\item{end}{Time value for end point. If not provided, the last observation or
event is used.}

\item{flows}{Return flow values? The default is "no" and no flows are
calculated. Other values are "total" (total flows summed up from beginning
to end timepoint), "average" (average flows per time unit, equal to total
flows divided by the projection duration), and "per_dt" (detailled flow
values are returned for each interval dt of the projection).}

\item{cached_ts, cached_ee}{Used for optimization by other functions, not for
use by the package user.}

\item{ignore_pulses}{Default to FALSE (i.e. apply pulses when projecting the
network system). It is set to TRUE when calculating steady-state flows.}
}
\value{
A network model object with a \code{"trajectory"} column.
}
\description{
Calculate the trajectories of a network model
}
\examples{
m <- aquarium_mod
m <- set_params(m, sample_params(m))
z <- project(m)
z <- project(m, flows = "per_dt")
z <- project(m, flows = "total")
z <- project(m, flows = "average")

}
