% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sif2igraph}
\alias{sif2igraph}
\title{SIF to igraph}
\usage{
sif2igraph(Path, directed = FALSE)
}
\arguments{
\item{Path}{A string or character vector indicating the path to the desired SIF file. The SIF file
could be on your local hard drive, cloud space, or on the internet.}

\item{directed}{Logical scalar, whether or not to create a directed graph.}
}
\value{
An igraph graph object.
}
\description{
This function imports and converts a SIF file from your local hard drive, cloud space,
or internet into a graph with an igraph class, which can then be used for the identification
of most influential nodes via the ivi function, for instance.
}
\examples{
\dontrun{
MyGraph <- sif2igraph(Path = "/Users/User1/Desktop/mygraph.sif", directed=FALSE)
}
}
\concept{network_reconstruction functions}
\keyword{SIF.to.igraph}
