% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{network_format}
\alias{network_format}
\title{Format network table}
\usage{
network_format(
  network_table,
  regulators = NULL,
  targets = NULL,
  abs_weight = TRUE
)
}
\arguments{
\item{network_table}{The weight data table of network.}

\item{regulators}{Regulators list.}

\item{targets}{Targets list.}

\item{abs_weight}{Logical value, default is \emph{\code{TRUE}},
whether to perform absolute value on weights,
and when set \code{abs_weight} to \emph{\code{TRUE}},
the output of weight table will create a new column named \code{Interaction}.}
}
\value{
Formated network table
}
\description{
Format network table
}
\examples{
data("example_matrix")
network_table <- inferCSN(example_matrix)

network_format(
  network_table,
  regulators = "g1"
)

network_format(
  network_table,
  regulators = "g1",
  abs_weight = FALSE
)

network_format(
  network_table,
  targets = "g3"
)

network_format(
  network_table,
  regulators = c("g1", "g3"),
  targets = c("g3", "g5")
)
}
