% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_toids.R
\name{add_toids}
\alias{add_toids}
\alias{add_toids.data.frame}
\alias{add_toids.hy}
\title{Add Downstream IDs}
\usage{
add_toids(x, return_dendritic = TRUE)

\method{add_toids}{data.frame}(x, return_dendritic = TRUE)

\method{add_toids}{hy}(x, return_dendritic = TRUE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{return_dendritic}{logical remove non dendritic paths if TRUE. Requires
a "divergence" flag where 1 is main and 2 is secondary.}
}
\value{
hy object with toid attribute
}
\description{
Generates a toid attribute from node topology by joining
tonode and fromnode attributes.
}
\details{
Required attributes: \code{fromnode}, \code{tonode}

Conditionally: \code{divergence} (if \code{return_dendritic = TRUE})
}
\examples{
g <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

x <- add_toids(hy(g))

y <- add_toids(g)

names(g)[1:4]

names(x)[1:4]

names(y)[1:4]

}
