% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_z7_canonical}
\alias{hexify_z7_canonical}
\title{Get canonical form of Z7 index}
\usage{
hexify_z7_canonical(index, max_iterations = 128L)
}
\arguments{
\item{index}{Z7 index string}

\item{max_iterations}{Maximum iterations for cycle detection (default 128)}
}
\value{
Canonical form (lexicographically smallest in cycle)
}
\description{
For Z7 indices that form cycles during decode/encode, returns the
lexicographically smallest index in the cycle. Provides stable
unique identifiers for aperture 7 grids.
}
\examples{
# These all return the same canonical form
hexify_z7_canonical("110001")
hexify_z7_canonical("110002")
}
\seealso{
Other hierarchical index: 
\code{\link{hexify_cell_to_index}()},
\code{\link{hexify_compare_indices}()},
\code{\link{hexify_default_index_type}()},
\code{\link{hexify_get_children}()},
\code{\link{hexify_get_parent}()},
\code{\link{hexify_get_resolution}()},
\code{\link{hexify_index_to_cell}()},
\code{\link{hexify_index_to_lonlat}()},
\code{\link{hexify_is_valid_index_type}()},
\code{\link{hexify_lonlat_to_index}()}
}
\concept{hierarchical index}
\keyword{internal}
