/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5HGmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5HGpkg.h"    

haddr_t
H5HG_get_addr(const H5HG_heap_t *heap)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(heap);

    FUNC_LEAVE_NOAPI(heap->addr)
} 

size_t
H5HG_get_size(const H5HG_heap_t *heap)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(heap);

    FUNC_LEAVE_NOAPI(heap->size)
} 

size_t
H5HG_get_free_size(const H5HG_heap_t *heap)
{
    
    FUNC_ENTER_NOAPI_NOINIT_NOERR

    assert(heap);

    FUNC_LEAVE_NOAPI(heap->obj[0].size)
} 
