% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cureem.R
\name{cureem}
\alias{cureem}
\title{Fit penalized mixture cure model using the E-M algorithm}
\usage{
cureem(
  formula,
  data,
  subset,
  x.latency = NULL,
  model = "cox",
  penalty = "lasso",
  penalty.factor.inc = NULL,
  penalty.factor.lat = NULL,
  thresh = 0.001,
  scale = TRUE,
  maxit = NULL,
  inits = NULL,
  lambda.inc = 0.1,
  lambda.lat = 0.1,
  gamma.inc = 3,
  gamma.lat = 3,
  ...
)
}
\arguments{
\item{formula}{an object of class "\code{formula}" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The response must be a survival object as returned by the \code{Surv} function while the variables on the right side of the formula are the covariates that are included in the incidence portion of the model.}

\item{data}{a data.frame in which to interpret the variables named in the \code{formula} or in the \code{subset} argument.}

\item{subset}{an optional expression indicating which subset of observations to be used in the fitting process, either a numeric or factor variable should be used in subset, not a character variable. All observations are included by default.}

\item{x.latency}{specifies the variables to be included in the latency portion of the model and can be either a matrix of predictors, a model formula with the right hand side specifying the latency variables, or the same data.frame passed to the \code{data} parameter. Note that when using the model formula syntax for \code{x.latency} it cannot handle \code{x.latency = ~ .}.}

\item{model}{type of regression model to use for the latency portion of mixture cure model. Can be "cox", "weibull", or "exponential" (default is "cox").}

\item{penalty}{type of penalty function. Can be "lasso", "MCP", or "SCAD" (default is "lasso").}

\item{penalty.factor.inc}{vector of binary indicators representing the penalty to apply to each incidence coefficient: 0 implies no shrinkage and 1 implies shrinkage. If not supplied, 1 is applied to all incidence variables.}

\item{penalty.factor.lat}{vector of binary indicators representing the penalty to apply to each latency coefficient: 0 implies no shrinkage and 1 implies shrinkage. If not supplied, 1 is applied to all latency variables.}

\item{thresh}{small numeric value. The iterative process stops when the differences between successive expected penalized complete-data log-likelihoods for both incidence and latency components are less than this specified level of tolerance (default is 10^-3).}

\item{scale}{logical, if TRUE the predictors are centered and scaled.}

\item{maxit}{integer specifying the maximum number of passes over the data for each lambda. If not specified, 100 is applied when \code{penalty = "lasso"} and 1000 is applied when \code{penalty = "MCP"} or \code{penalty = "SCAD"}.}

\item{inits}{an optional list specifiying the initial value for the incidence intercept (\code{itct}), a numeric vector for the unpenalized incidence coefficients (\code{b_u}), and a numeric vector for unpenalized latency coefficients (\code{beta_u}).  For parametric models, it should also include a numeric value for the rate parameter (\code{lambda}) when \code{model = "weibull"} or \code{model = "exponential"}, and a numeric value for the shape parameter (\code{alpha}) when \code{model = "weibull"}. When \code{model = "cox"}, it should also include a numeric vector for the latency survival probabilities \eqn{S_u(t_i|w_i)} for i=1,...,N (\code{survprob}). Penalized coefficients are initialized to zero. If \code{inits} is not specified or improperly specified, initialization is automatically provided by the function.}

\item{lambda.inc}{numeric value for the penalization parameter \eqn{\lambda} for variables in the incidence portion of the model.}

\item{lambda.lat}{numeric value for the penalization parameter \eqn{\lambda} for variables in the latency portion of the model.}

\item{gamma.inc}{numeric value for the penalization parameter \eqn{\gamma} for variables in the incidence portion of the model when \code{penalty = "MCP"} or \code{penalty = "SCAD"} (default is 3).}

\item{gamma.lat}{numeric value for the penalization parameter \eqn{\gamma} for variables in the latency portion of the model when \code{penalty = "MCP"} or \code{penalty = "SCAD"} (default is 3).}

\item{...}{additional arguments.}
}
\value{
\item{b_path}{Matrix representing the solution path of the coefficients in the incidence portion of the model. Row is step and column is variable.}

\item{beta_path}{Matrix representing the solution path of lthe coefficients in the latency portion of the model. Row is step and column is variable.}

\item{b0_path }{Vector representing the solution path of the intercept in the incidence portion of the model.}

\item{logLik.inc }{Vector representing the expected penalized complete-data log-likelihood for the incidence portion of the model for each step in the solution path.}

\item{logLik.lat }{Vector representing the expected penalized complete-data log-likelihood for the latency portion of the model for each step in the solution path.}

\item{x.incidence}{Matrix representing the design matrix of the incidence predictors.}

\item{x.latency}{Matrix representing the design matrix of the latency predictors.}

\item{y}{Vector representing the survival object response as returned by the \code{Surv} function }

\item{model}{Character string indicating the type of regression model used for the latency portion of mixture cure model ("weibull" or "exponential").}

\item{scale}{Logical value indicating whether the predictors were centered and scaled.}

\item{method}{Character string indicating the EM alogoritm was used in fitting the mixture cure model.}

\item{rate_path}{Vector representing the solution path of the rate parameter for the Weibull or exponential density in the latency portion of the model.}

\item{alpha_path}{Vector representing the solution path of the shape parameter for the Weibull density in the latency portion of the model.}

\item{call}{the matched call.}
}
\description{
Fits a penalized parametric and semi-parametric mixture cure model (MCM) using the E-M algorithm with user-specified penalty parameters. The lasso (L1), MCP, and SCAD penalty is supported for the Cox MCM while only lasso is currently supported for parametric MCMs.
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 80, J = 100, nTrue = 10, A = 1.8)
training <- temp$Training
fit <- cureem(Surv(Time, Censor) ~ ., data = training, x.latency = training,
                 model = "cox", penalty = "lasso",
                 lambda.inc = 0.1, lambda.lat = 0.1, gamma.inc = 6, gamma.lat = 10)
}
\references{
Archer, K. J., Fu, H., Mrozek, K., Nicolet, D., Mims, A. S., Uy, G. L., Stock, W., Byrd, J. C., Hiddemann, W., Braess, J., Spiekermann, K., Metzeler, K. H., Herold, T., Eisfeld, A.-K. (2024) Identifying long-term survivors and those at higher or lower risk of relapse among patients with cytogenetically normal acute myeloid leukemia using a high-dimensional mixture cure model. \emph{Journal of Hematology & Oncology}, \bold{17}:28.
}
\seealso{
\code{\link{cv_cureem}}
}
\keyword{models}
\keyword{regression}
