% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyoneway.R
\name{svyoneway}
\alias{svyoneway}
\title{Test for Equal Means for survey design object}
\usage{
svyoneway(formula, design, ...)
}
\arguments{
\item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs} gives the sample
values and \code{rhs} the corresponding groups}

\item{design}{a survey design object}

\item{...}{additional parameters passed to \code{\link[survey:regTermTest]{survey::regTermTest()}}}
}
\value{
an object of class \code{"htest"}
}
\description{
This function allows to compare several means using \code{\link[survey:svyglm]{survey::svyglm()}}. More
precisely, this is a wrapper for \code{survey::regTermTest(m, "group")} where
\code{m <- survey::svyglm(x ~ group, design)}.
}
\examples{
\dontshow{if (rlang::is_installed(c("survey", "srvyr"))) withAutoprint(\{ # examplesIf}
svyoneway(
  Petal.Length ~ Species,
  design = srvyr::as_survey(iris)
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[stats:oneway.test]{stats::oneway.test()}} for classic data frames
}
\keyword{htest}
