% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_reg_summary.R
\name{tbl_reg_summary}
\alias{tbl_reg_summary}
\title{Data Summary Table}
\usage{
tbl_reg_summary(
  data,
  by = NULL,
  label = NULL,
  statistic = list(all_continuous() ~ c("{N_nonmiss}", "{mean} ({sd})",
    "{median} ({p25}, {p75})", "{min}, {max}", "{N_miss}"), all_categorical() ~
    "{n} ({p}\%)"),
  digits = NULL,
  type = NULL,
  value = NULL,
  missing = c("no", "yes", "ifany"),
  missing_text = "Unknown",
  missing_stat = "{N_miss}",
  sort = all_categorical(FALSE) ~ "alphanumeric",
  percent = c("column", "row", "cell"),
  include = everything()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{by}{A column name (quoted or unquoted) in \code{data.} Summary statistics
will be calculated separately for each level of the by variable
(e.g. \code{by = trt}). If \code{NULL}, summary statistics are calculated using all observations.}

\item{label}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{statistic}{List of formulas specifying types of summary statistics
to display for each variable.}

\item{digits}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s)
or function(s). If not specified, default formatting is assigned
via \code{assign_summary_digits()}. See below for details.}

\item{type}{List of formulas specifying variable types.
Accepted values are \code{c("continuous", "continuous2", "categorical", "dichotomous")},
e.g. \code{type = list(age ~ "continuous", female ~ "dichotomous")}.
If type not specified for a variable, the function will default to an appropriate summary type.}

\item{value}{List of formulas specifying the value to display for dichotomous
variables. gtsummary selectors, e.g. \code{all_dichotomous()}, cannot be used with this argument.}

\item{missing, missing_text, missing_stat}{Arguments dictating how and if missing values are presented:
\itemize{
\item \code{missing}: must be one of \code{c("ifany", "no", "always")}
\item \code{missing_text}: string indicating text shown on missing row. Default is \code{"Unknown"}
\item \code{missing_stat}: statistic to show on missing row. Default is \code{"{N_miss}"}.
Possible values are \code{N_miss}, \code{N_obs}, \code{N_nonmiss}, \code{p_miss}, \code{p_nonmiss}.
}}

\item{sort}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies sorting to perform for categorical variables.
Values must be one of \code{c("alphanumeric", "frequency")}.
Default is \code{all_categorical(FALSE) ~ "alphanumeric"}.}

\item{percent}{(\code{string})\cr
Indicates the type of percentage to return.
Must be one of \code{c("column", "row", "cell")}. Default is \code{"column"}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}
}
\value{
a 'tbl_reg_summary' object
}
\description{
Function wraps \code{gtsummary::tbl_summary()} to create a data summary
table often seen in regulatory submissions. Continuous variable summaries
are shown on multiple lines with additional summary statistics and percentages
are shown for categorical variables; precision levels estimated based on values observed.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_reg_summary_ex1.png}{options: width=65\%}}
}

\examples{
tbl_reg_summary_ex1 <-
  df_patient_characteristics \%>\%
  tbl_reg_summary(by = trt, include = c(marker, status))

}
\seealso{
See \href{https://www.danieldsjoberg.com/gtsummary/reference/tbl_summary.html}{\code{gtsummary::tbl_summary()}} help file

See \href{https://www.danieldsjoberg.com/gtsummary/articles/tbl_summary.html}{vignette} for detailed tutorial
}
