% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_gtable}
\alias{as_gtable}
\title{Transform a \strong{gt} table to a \code{gtable} object}
\usage{
as_gtable(data, plot = FALSE, text_grob = grid::textGrob)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{plot}{\emph{Render through the graphics device?}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

The \code{plot} option determines whether the \code{gtable} object should be rendered
on the graphics device.}

\item{text_grob}{\emph{Function for drawing text}

\code{function} // \emph{default:} \code{grid::textGrob}

A \code{function} which will be used to draw text. Defaults to
\code{grid::textGrob()} but can be swapped to \code{gridtext::richtext_grob()} to
better render HTML content.}
}
\value{
A \code{gtable} object.
}
\description{
\code{as_gtable()} performs the transformation of a \code{gt_tbl} object to a
\code{\link[gtable:gtable]{gtable}} object.
}
\section{Function ID}{

13-6
}

\section{Function Introduced}{

\code{v0.11.0} (July 9, 2024)
}

\seealso{
Other table export functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{as_word}()},
\code{\link{extract_body}()},
\code{\link{extract_cells}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
