% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFSformat.R
\name{CFS_freq}
\alias{CFS_freq}
\title{frequency distributions by geo-location per species}
\usage{
CFS_freq(
  tr_meta,
  freq.label_data = "",
  freq.uid_level = "uid_radius",
  freq.cutoff_year = -999,
  freq.geo_resolution = NULL
)
}
\arguments{
\item{tr_meta}{meta table from function CFS_format()}

\item{freq.label_data}{description of tr_meta}

\item{freq.uid_level}{which uid level to count(uid_project, uid_site, uid_tree, uid_meas, uid_sample, uid_radius)}

\item{freq.cutoff_year}{cut-off year for a subset which series were recorded on or after}

\item{freq.geo_resolution}{resolution of longitude and latitude in degree, default: c(5,5)}
}
\value{
a data table of counts of uid by latitude-longitude per species
}
\description{
frequency distributions by geo-location per species
}
\examples{


# treated ring measurement
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# Compute frequency statistics at radius level
dt.freq <- CFS_freq(
  dt.samples_trt$tr_all_wide,
  freq.label_data = "demo-samples",
  freq.uid_level  = "uid_radius"
)
class(dt.freq)
}
