% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_lca.R
\docType{class}
\name{Lca}
\alias{Lca}
\alias{LcaPrior-class}
\alias{Lca-class}
\alias{LcaPrior}
\title{Latent Class Analysis Model Prior class}
\usage{
LcaPrior(beta = 1)

Lca(alpha = 1, beta = 1)
}
\arguments{
\item{beta}{Dirichlet prior parameter for all the categorical feature (default to 1)}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{LcaPrior-class} object

a \code{Lca-class} object
}
\description{
An S4 class to represent a Latent Class Analysis model
Such model can be used to cluster a data.frame \eqn{X} with several columns of factors with the following generative model :
\deqn{\pi \sim \textrm{Dirichlet}(\alpha),}
\deqn{\forall k, \forall j, \quad \theta_{kj} \sim \textrm{Dirichlet}_{d_j}(\beta),}
\deqn{Z_i \sim \mathcal{M}_K(1,\pi),}
\deqn{\forall j=1, \ldots, p, \quad X_{ij}|Z_{ik}=1 \sim \mathcal{M}_{d_j}(1, \theta_{kj}),}
These classes mainly store the prior parameters value (\eqn{\alpha,\beta}) of this generative model.
The \code{Lca-class} must be used when fitting a simple Latent Class Analysis whereas the \code{LcaPrior-class} must be used when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
LcaPrior()
LcaPrior(beta = 0.5)
Lca()
Lca(beta = 0.5)
}
\seealso{
\code{\link{LcaFit-class}}, \code{\link{LcaPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
