% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cite_packages.R
\name{cite_packages}
\alias{cite_packages}
\title{Cite R packages used in a project}
\usage{
cite_packages(
  output = c("file", "paragraph", "table", "citekeys"),
  out.dir = NULL,
  out.format = c("html", "docx", "pdf", "Rmd", "md", "tex-fragment", "tex-document"),
  citation.style = NULL,
  pkgs = "All",
  omit = c("grateful"),
  cite.tidyverse = TRUE,
  dependencies = FALSE,
  include.RStudio = FALSE,
  passive.voice = FALSE,
  out.file = "grateful-report",
  bib.file = "grateful-refs",
  ...
)
}
\arguments{
\item{output}{Either
\itemize{
\item "file" to generate a separate document with formatted citations
for all packages;
\item "paragraph" to return a paragraph with in-text citations of used packages,
suitable to be used within an 'R Markdown' or 'Quarto' document;
\item "table" to return a table with package name, version, and citations, to be used
in 'R Markdown' or 'Quarto';
\item "citekeys" to return a vector with citation keys.
}

In all cases, a BibTeX file with package references is saved on disk
(see \code{bib.file}).}

\item{out.dir}{Directory to save the output document and a BibTeX file with
the references. It is recommended to set \code{out.dir = getwd()}.}

\item{out.format}{Output format when \code{output = "file"}:
either "html" (the default), "docx" (Word), "pdf",
"tex-fragment" (LaTeX fragment to be inserted into another LaTeX document),
"tex-document" (full LaTeX document), "Rmd", or "md" (markdown).
(Note that choosing "pdf" requires a working installation of LaTeX,
see \url{https://yihui.org/tinytex/}).}

\item{citation.style}{Optional. Citation style to format references for a
particular journal
(see \url{https://bookdown.org/yihui/rmarkdown-cookbook/bibliography.html}).
If the CSL is not available in \code{out.dir}, it will be downloaded
automatically from the official
\href{https://github.com/citation-style-language/styles}{GitHub repository}
using \code{\link[=get_csl]{get_csl()}}.
If using \code{\link[=cite_packages]{cite_packages()}} within an R Markdown or Quarto
document, \code{citation.style} should be \code{NULL} (the default). The citation style
should instead be defined in the YAML metadata of the document
(see \url{https://pakillo.github.io/grateful/#using-grateful-with-rmarkdown-or-quarto}).}

\item{pkgs}{Character. Either "All" to include all packages used in scripts
within the project/folder (the default), or "Session" to include only packages
used in the current session.
Alternatively, \code{pkgs} can also be a character vector of package names to
get citations for. To cite R as well as the given packages,
include "base" in \code{pkgs} (see examples).}

\item{omit}{Character vector of package names to be omitted from the citation
report. \code{grateful} is omitted by default. Use \code{omit = NULL} to include all
packages.}

\item{cite.tidyverse}{Logical. If \code{TRUE}, all tidyverse packages
(dplyr, ggplot2, etc) will be collapsed into a single citation
of the 'tidyverse', as recommended by the tidyverse team.}

\item{dependencies}{Logical. Include the dependencies of your used packages?
If \code{TRUE}, will include all the packages that your used packages depend on.}

\item{include.RStudio}{Logical. If \code{TRUE}, adds a citation for the
current version of RStudio.}

\item{passive.voice}{Logical. If \code{TRUE}, uses passive voice in any paragraph
generated for citations.}

\item{out.file}{Desired name of the citation report to be created if
\code{output = "file"}. Default is "grateful-report" (without extension).}

\item{bib.file}{Desired name for the BibTeX file containing packages references
("grateful-refs" by default).}

\item{...}{Other parameters passed to \code{\link[renv:dependencies]{renv::dependencies()}}.}
}
\value{
If \code{output = "file"}, \code{cite_packages} will save two files in \code{out.dir}:
a BibTeX file containing package references and a citation report with formatted
citations. \code{cite_packages} will return the path to the citation report invisibly.
If \code{output = "table"} or \code{output = "paragraph"}, \code{cite_packages} will return
a table or paragraph with package citations suitable to be used
within 'R Markdown' or 'Quarto' documents.
}
\description{
Find R packages used in a project, create a BibTeX file of references,
and generate a document with formatted package citations. Alternatively,
\code{cite_packages} can be run directly within an 'R Markdown' or 'Quarto' document to
automatically include a paragraph citing all used packages and generate
a bibliography.
}
\details{
\code{cite_packages} is a wrapper function that collects package names and versions
and saves their citation information in a BibTeX file
(using \code{\link[=get_pkgs_info]{get_pkgs_info()}}).

Then, the function is designed to handle different use cases:

If \code{output = "file"}, \code{cite_packages()} will generate an 'R Markdown' file
which includes a paragraph with in-text citations of all packages,
as well as a references list.
This document can be knitted to various formats via \code{out.format}.
References can be formatted for a particular journal using \code{citation.style}.
Thus, \code{output = "file"} is best for obtaining a document separate from R,
to just cut and paste citations.

If \code{output = "paragraph"}, \code{cite_packages()} will return
a paragraph with in-text citations of all packages,
suitable to be used directly in an 'R Markdown' or 'Quarto' document.
To do so, include a reference to the generated \code{bib.file}
bibliography file in the YAML header of the document
(see \url{https://pakillo.github.io/grateful/index.html#using-grateful-within-rmarkdown}).

Alternatively, if \code{output = "table"}, \code{cite_packages()} will return
a table with package names, versions, and citations. Thus, if using 'R Markdown'
or 'Quarto', you can choose between getting a table or a text paragraph citing all packages.

Finally, you can use \code{output = "citekeys"} to obtain a vector of citation keys,
and then call \code{\link[=nocite_references]{nocite_references()}} within an 'R Markdown' or 'Quarto' document
to cite these packages in the reference list without mentioning them in the text.
}
\section{Limitations}{


Citation keys are not guaranteed to be preserved when regenerated,
particularly when packages are updated. This instability is not an issue
when citations are used programmatically, as in the example below. But if
references are put into the text manually, they may need to be updated
periodically.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# To build a standalone document for citations
cite_packages(out.dir = tempdir())

# Format references for a particular journal:
cite_packages(citation.style = "peerj", out.dir = tempdir())

# Choose different output format:
cite_packages(out.format = "docx", out.dir = tempdir())

# Cite only packages currently loaded:
cite_packages(pkgs = "Session", out.dir = tempdir())

# Cite only user-provided packages:
cite_packages(pkgs = c("renv", "remotes", "knitr"), out.dir = tempdir())

# Cite R as well as user-provided packages
cite_packages(pkgs = c("base", "renv", "remotes", "knitr"), out.dir = tempdir())


# To include citations in an R Markdown or Quarto file

# include this in YAML header:
# bibliography: grateful-refs.bib

# then call cite_packages within an R chunk:
cite_packages(output = "paragraph", out.dir = tempdir())

# To include package citations in the reference list of an Rmarkdown document
# without citing them in the text, include this in a chunk:
nocite_references(cite_packages(output = "citekeys", out.dir = tempdir()))
\dontshow{\}) # examplesIf}
}
