% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{neg_log_likelihood.GPModel}
\alias{neg_log_likelihood.GPModel}
\title{Evaluate the negative log-likelihood}
\usage{
\method{neg_log_likelihood}{GPModel}(gp_model, cov_pars, y,
  fixed_effects = NULL, aux_pars = NULL)
}
\arguments{
\item{gp_model}{A \code{GPModel}}

\item{cov_pars}{A \code{vector} with \code{numeric} elements. 
Covariance parameters of Gaussian process and  random effects}

\item{y}{A \code{vector} with response variable data}

\item{fixed_effects}{A \code{numeric} \code{vector} with fixed effects, e.g., containing a linear predictor. 
The length of this vector needs to equal the number of training data points.}

\item{aux_pars}{A \code{vector} with \code{numeric} elements. 
Additional parameters for non-Gaussian likelihoods (e.g., shape parameter of a gamma or negative_binomial likelihood)}
}
\value{
A \code{GPModel}
}
\description{
Evaluate the negative log-likelihood. If there is a linear fixed effects
predictor term, this needs to be calculated "manually" prior to calling this 
function (see example below)
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")
gp_model <- GPModel(group_data = group_data, likelihood="gaussian")
X1 <- cbind(rep(1,dim(X)[1]), X)
coef <- c(0.1, 0.1, 0.1)
fixed_effects <- as.numeric(X1 \%*\% coef)
neg_log_likelihood(gp_model, y = y, cov_pars = c(0.1,1,1), 
                   fixed_effects = fixed_effects)
}
}
\author{
Fabio Sigrist
}
