% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{plot_cut}
\alias{plot_cut}
\title{Cut plotting}
\usage{
plot_cut(K, G)
}
\arguments{
\item{K}{Cut to be plotted; an output list returned by some
cut-building function, see below.}

\item{G}{Graph on which to superimpose the cut.}
}
\value{
This function is called for its side effect of plotting.
}
\description{
Plot of a cut in a graph.
}
\details{
It plots a graph, then superimposes a cut, drawing the associated
vertex set in a different color.
}
\examples{
K10 <- make_full_graph(10)   # Max cut of size 25
c0 <- build_cut_random(K10)
plot_cut(c0, K10)

}
\seealso{
\link{build_cut_random} builds a random cut,
\link{build_cut_greedy} builds a cut using a greedy algorithm,
\link{improve_cut_flip} uses local search to improve a cut obtained
by other methods, \link{compute_cut_weight} computes cut size,
weight and edges.
}
\author{
Cesar Asensio
}
