% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{plot.swarmPlot}
\alias{plot.swarmPlot}
\title{Plotting method for swarmPlot objects}
\usage{
\method{plot}{swarmPlot}(
  x,
  type = "l",
  col = "grey",
  xlim = NULL,
  ylim = NULL,
  xlab = "x",
  ylab = "y",
  main = NULL,
  asp = NA,
  sub = NULL,
  log = "",
  ann = par("ann"),
  axes = TRUE,
  frame.plot = axes,
  bg = NA,
  pch = 1,
  cex = 1,
  lty = 1,
  lwd = 1,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{swarmPlot object}

\item{type}{see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{col}{color to be used for all curves and points}

\item{xlim}{limits of the X axis, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{ylim}{limits of the Y axis, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{xlab}{label for the X axis, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{ylab}{label for the Y axis, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{main}{main plot title, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{asp}{plot aspect ratio, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{sub}{plot subtitle, see  \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{log}{log scale for any axis? see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{ann}{plot annotation indications, see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{axes}{should axes be set? see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{frame.plot}{should the plot be framed? see \code{\link[graphics:plot.default]{graphics::plot.default()}}}

\item{bg}{fill color for the data points if certain \code{pch} symbols are used}

\item{pch}{symbol for the data points, see \code{\link[graphics:points]{graphics::points()}}}

\item{cex}{symbol size for the data points}

\item{lty}{line style for the curves}

\item{lwd}{line thickness for the curves}

\item{add}{logical, add results to an existing plot?}

\item{...}{further parameters to the plotting function}
}
\value{
Nothing. The function is called to make a plot.
}
\description{
Produces a plot for objects obtained by means of \code{\link[=swarmPlot]{swarmPlot()}}. These are lists of two-element
list, respectively giving the (x,y) coordinates of a series of points defining a curve. They
are typically obtained out of a \code{\link[=DataFrameStack]{DataFrameStack()}}, and each curve represents a a certain relevant
summary of one of the elements of the stack. All parameters of \code{\link[graphics:plot.default]{graphics::plot.default()}}
are available, plus the following
}
\examples{
dm = list(point=1:100, var=LETTERS[1:2], rep=paste("r",1:5, sep=""))
ar = array(rnorm(1000), dim=c(100,2,5), dimnames = dm)
dfs = DataFrameStack(ar, stackDim="rep")
rs = swarmPlot(dfs, PLOTFUN=function(x) density(x[,1]), .plotargs=FALSE)
plot(rs, col="yellow", lwd=3)
}
