% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_absences.R
\name{generate_pa_random}
\alias{generate_pa_random}
\title{Generate Random Pseudo-Absences}
\usage{
generate_pa_random(
  presences,
  study_area,
  raster_stack,
  predictor_variables,
  coords = c("decimalLongitude", "decimalLatitude"),
  ratio = 1,
  attempts = 100,
  seed = NULL
)
}
\arguments{
\item{presences}{Data frame containing presence points.}

\item{study_area}{Spatial polygon defining the study area (`sf` object).}

\item{raster_stack}{`SpatRaster` object containing covariate data.}

\item{predictor_variables}{Character vector of the predictor variables selected for this species.}

\item{coords}{Character vector specifying the column names for latitude and longitude. Defaults to `c("decimalLongitude", "decimalLatitude")`.}

\item{ratio}{Ratio of pseudo-absences to presences (default 1 = balanced).}

\item{attempts}{Integer specifying the number of attempts to generate exact pseudo-absences. Defaults to 100.}

\item{seed}{Optional random seed.}
}
\value{
Data frame containing pseudo-absence points with coordinates, timestamp, pa = 0, and covariates.
}
\description{
This function generates pseudo-absence points randomly across the study area (random background),
optionally applying spatial thinning to match presence filtering strategy.
}
