% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anova.R, R/effects.R, R/emmeans.R
\name{Anova.glmmTMB}
\alias{Anova.glmmTMB}
\alias{Effect.glmmTMB}
\alias{downstream_methods}
\alias{emmeans.glmmTMB}
\title{Downstream methods}
\usage{
Anova.glmmTMB(
  mod,
  type = c("II", "III", 2, 3),
  test.statistic = c("Chisq", "F"),
  component = "cond",
  vcov. = vcov(mod)[[component]],
  singular.ok,
  include.rankdef.cols = FALSE,
  ...
)

Effect.glmmTMB(focal.predictors, mod, ...)
}
\arguments{
\item{mod}{a glmmTMB model}

\item{type}{type of test, \code{"II"}, \code{"III"}, \code{2}, or \code{3}.  Roman numerals are equivalent to the corresponding Arabic numerals. See \code{\link[car]{Anova}} for details.}

\item{test.statistic}{unused: only valid choice is "Chisq" (i.e., Wald chi-squared test)}

\item{component}{which component of the model to test/analyze ("cond", "zi", or "disp")
or, in \pkg{emmeans} only, "response" or "cmean" as described in Details.}

\item{vcov.}{variance-covariance matrix (usually extracted automatically)}

\item{singular.ok}{OK to do ANOVA with singular models (unused) ?}

\item{include.rankdef.cols}{include all columns of a rank-deficient model matrix?}

\item{\dots}{Additional parameters that may be supported by the method.}

\item{focal.predictors}{a character vector of one or more predictors in the
model in any order.}
}
\description{
Methods have been written that allow \code{glmmTMB} objects to be used with
several downstream packages that enable different forms of inference.
For some methods (\code{Anova} and \code{emmeans}, but \emph{not} \code{effects} at present),
set the \code{component} argument
to "cond" (conditional, the default), "zi" (zero-inflation) or "disp" (dispersion) in order to produce results
for the corresponding part of a \code{glmmTMB} model. 
Support for \pkg{emmeans} also allows additional options 
\code{component = "response"} (response means taking both the \code{cond} and
\code{zi} components into account), and \code{component = "cmean"} (mean of the 
[possibly truncated] conditional distribution). 

In particular,
\itemize{
\item \code{car::Anova} constructs type-II and type-III Anova tables
for the fixed effect parameters of any component
\item the \code{emmeans} package computes estimated marginal means (previously known as least-squares means)
for the fixed effects of any component, or predictions with \code{type = "response"} or
\code{type = "component"}. Note: In hurdle models, 
\code{component = "cmean"} produces means
of the truncated conditional distribution, while 
\code{component = "cond", type = "response"} produces means of the \emph{untruncated}
conditional distribution.
\item the \code{effects} package computes graphical tabular effect displays
(only for the fixed effects of the conditional component)
}
}
\details{
While the examples below are disabled for earlier versions of
R, they may still work; it may be necessary to refer to private
versions of methods, e.g. \code{glmmTMB:::Anova.glmmTMB(model, ...)}.
}
\examples{
warp.lm <- glmmTMB(breaks ~ wool * tension, data = warpbreaks)
salamander1 <- up2date(readRDS(system.file("example_files","salamander1.rds",package="glmmTMB")))
if (require(emmeans)) withAutoprint({
    emmeans(warp.lm, poly ~ tension | wool)
    emmeans(salamander1, ~ mined, type="response")  # conditional means
    emmeans(salamander1, ~ mined, component="cmean")     # same as above, but re-gridded
    emmeans(salamander1, ~ mined, component="zi", type="response")  # zero probabilities
    emmeans(salamander1, ~ mined, component="response")  # response means including both components
})
if (getRversion() >= "3.6.0") {
   if (require(car)) withAutoprint({
       Anova(warp.lm,type="III")
       Anova(salamander1)
       Anova(salamander1, component="zi")
   })
   if (require(effects)) withAutoprint({
       plot(allEffects(warp.lm))
       plot(allEffects(salamander1))
   })
}
}
