% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-filter-spct.r
\name{R_plot}
\alias{R_plot}
\title{Create a complete ggplot for a reflector spectrum.}
\usage{
R_plot(
  spct,
  w.band,
  range,
  pc.out,
  label.qty,
  span,
  wls.target,
  annotations,
  by.group,
  geom,
  text.size,
  chroma.type,
  idfactor,
  facets,
  ylim,
  na.rm,
  ...
)
}
\arguments{
\item{spct}{a filter_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{annotations}{a character vector.}

\item{by.group}{logical flag If TRUE repeated identical annotation layers are
added for each group within a plot panel as needed for animation. If
\code{FALSE}, the default, single layers are added per panel.}

\item{geom}{character.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped
to the spectra and the user needs to use 'ggplot2' functions to manually
map an aesthetic or use facets for the spectra.}

\item{facets}{logical or integer Indicating if facets are to be created for
the levels of \code{idfactor} when \code{spct} contain multiple spectra in
long form.}

\item{ylim}{numeric y axis limits,}

\item{na.rm}{logical.}

\item{...}{currently ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a reflector_spct
reflectance.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\keyword{internal}
