% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_concat}
\alias{ggml_concat}
\title{Concatenate Tensors (Graph)}
\usage{
ggml_concat(ctx, a, b, dim = 0)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First tensor}

\item{b}{Second tensor (must match a in all dimensions except the concat dim)}

\item{dim}{Dimension along which to concatenate (0-3)}
}
\value{
Concatenated tensor
}
\description{
Concatenates two tensors along a specified dimension.
CRITICAL for KV-cache operations in transformers.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 3)
b <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 2)
ggml_set_f32(a, rnorm(12))
ggml_set_f32(b, rnorm(8))
# Concatenate along dimension 1: result is 4x5
c <- ggml_concat(ctx, a, b, 1)
graph <- ggml_build_forward_expand(ctx, c)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
