% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle_dither.R, R/custom_dither.R,
%   R/halftone_dither.R, R/ordered_dither.R
\name{with_circle_dither}
\alias{with_circle_dither}
\alias{with_custom_dither}
\alias{with_halftone_dither}
\alias{with_ordered_dither}
\title{Dither image using a threshold dithering map}
\usage{
with_circle_dither(
  x,
  map_size = 7,
  levels = NULL,
  black = TRUE,
  colourspace = "sRGB",
  offset = NULL,
  ...
)

with_custom_dither(
  x,
  map = "checks",
  levels = NULL,
  colourspace = "sRGB",
  offset = NULL,
  ...
)

with_halftone_dither(
  x,
  map_size = 8,
  levels = NULL,
  angled = TRUE,
  colourspace = "sRGB",
  offset = NULL,
  ...
)

with_ordered_dither(x, map_size = 8, levels = NULL, colourspace = "sRGB", ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{map_size}{One of 2, 3, 4, or 8. Sets the threshold map used for
dithering. The larger, the better approximation of the input colours}

\item{levels}{The number of threshold levels in each channel. Either a single
integer to set the same number of levels in each channel, or 3 values to set
the levels individually for each colour channel}

\item{black}{Should the map consist of dark circles expanding into the light,
or the reverse}

\item{colourspace}{In which colourspace should the dithering be calculated}

\item{offset}{The angle offset between the colour channels}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}

\item{map}{The name of the threshold map to use as understood by
\code{\link[magick:color]{magick::image_ordered_dither()}}}

\item{angled}{Should the halftone pattern be at an angle or orthogonal}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
These filters reduces the number of colours in your layer and uses various
threshold maps along with a dithering algorithm to disperse colour error.
}
\examples{
\dontshow{if (!ggfx:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)

# Ordered dither
ggplot(faithfuld, aes(waiting, eruptions)) +
  with_ordered_dither(
    geom_raster(aes(fill = density), interpolate = TRUE)
  ) +
  scale_fill_continuous(type = 'viridis')

# Halftone dither
ggplot(faithfuld, aes(waiting, eruptions)) +
  with_halftone_dither(
    geom_raster(aes(fill = density), interpolate = TRUE)
  ) +
  scale_fill_continuous(type = 'viridis')

# Circle dither with offset
ggplot(faithfuld, aes(waiting, eruptions)) +
  with_circle_dither(
    geom_raster(aes(fill = density), interpolate = TRUE),
    offset = 29,
    colourspace = 'cmyk'
  ) +
  scale_fill_continuous(type = 'viridis')
\dontshow{\}) # examplesIf}
}
\seealso{
Other dithering filters: 
\code{\link{with_dither}()}
}
\concept{dithering filters}
