% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_arrow.R
\name{discrete_arrow_scales}
\alias{discrete_arrow_scales}
\alias{scale_arrow_head_discrete}
\alias{scale_arrow_fins_discrete}
\alias{scale_arrow_mid_discrete}
\title{Discrete arrow scales}
\usage{
scale_arrow_head_discrete(values = NULL, aesthetics = "arrow_head", ...)

scale_arrow_fins_discrete(values = NULL, aesthetics = "arrow_fins", ...)

scale_arrow_mid_discrete(values = NULL, aesthetics = "arrow_mid", ...)
}
\arguments{
\item{values}{One of the following:
\itemize{
\item A \verb{<character>} vector of arrow function names, without the
\code{arrow_}-prefix, such as \code{"head_wings"} or \code{"fins_line"}.
\item An unnested \verb{<list>}, possibly mixed \verb{<list>}, containing any of the
following elements:
\itemize{
\item A single \verb{<character>} as described above.
\item A \verb{<function>} that when called without any arguments produces
a 2-column \verb{<matrix>} that can be used as an arrow.
\item A 2-column \verb{<matrix>} giving a polygon to use as an arrow.
}
\item \code{NULL}, which defaults to a built-in palette with a maximum of 3 arrows.
}}

\item{aesthetics}{The names of the aesthetics that this scale works with}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{scale_name}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The name of the scale
that should be used for error messages associated with this scale.}
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:pal_hue]{scales::pal_hue()}}).}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\value{
A \verb{<Scale>} that can be added to a plot.
}
\description{
These scales can map discrete input to various sorts of arrow shapes.
The arrow head, arrow fins and middle arrows have separate scales.
}
\examples{
# A standard arrow plot
p <- ggplot(whirlpool(5), aes(x, y, colour = group)) +
  geom_arrow(length_head = 10, length_fins = 10, arrow_head = NULL)

# A character vector naming arrow shapes as arrow head scale
p + aes(arrow_head = group) +
  scale_arrow_head_discrete(values = c(
      "head_wings", "head_line", "head_minimal", "fins_line", "fins_feather"
  ))

# A mixed list with arrows as arrow fins scale
p + aes(arrow_fins = group) +
  scale_arrow_fins_discrete(values = list(
    "head_wings",              # Using a character
    arrow_head_wings(20, 100), # Using an arrow function
    NULL,                      # No arrow
    matrix(c(1, 0, 0, 0, 0.5, -0.5), ncol = 2), # A matrix
    "fins_feather"
  ))
}
