% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_cloud.R
\docType{data}
\name{geom_cloud}
\alias{geom_cloud}
\alias{GeomCloud}
\title{geom_cloud}
\arguments{
\item{steps}{The integer number of steps, or equivalently, the number of
overlapping ribbons. A larger number makes a smoother cloud
at the possible expense of rendering time. Values larger than
around 20 are typically not necessary.}

\item{max_alpha}{The maximum alpha at the maximum density. The cloud
will have alpha no greater than this value.}

\item{se_mult}{The \sQuote{multiplier} of standard errors of the given
\code{ymin} and \code{ymax}. If these are at one standard error,
then let \code{se_mult} take the default value of 1.}
}
\description{
Draw a normal uncertainty cloud as a ribbon

Draws overlapping ribbons of the same identity to create 
a cloud of (Gaussian) uncertainty. Similar to an errorbar geom in
use, but visually less distracting (sometimes).

Geom Proto
}
\details{
Assumes that \code{ymin} and \code{ymax} are plotted at a 
fixed number of standard errors away from \code{y}, then computes
a Gaussian density with that standard deviation, plotting a cloud
(based on \code{geom_ribbon}) with alpha proportional to the density.
This appears as a vertical \sQuote{cloud} of uncertainty. In use,
this geom should be comparable to \code{geom_errorbar}.

A sample output from \code{geom_cloud}:

\if{html}{
\figure{geom_cloud-1.png}{options: width="100\%" alt="Figure: geom_cloud-1.png"}
}
\if{latex}{
\figure{geom_cloud-1.png}{options: width=10cm}
}
}
\note{
This is a thin wrapper on the \code{geom_ribbon} geom.
}
\section{Aesthetics}{

\code{geom_cloud} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \strong{\code{ymin}}
  \item \strong{\code{ymax}}
  \item \code{fill}
}
Only one of \code{ymin} and \code{ymax} is strictly required.
}

\examples{
set.seed(2134)
nobs <- 200
mydat <- data.frame(grp=sample(c(0,1),nobs,replace=TRUE),
  colfac=sample(letters[1:2],nobs,replace=TRUE),
  rowfac=sample(letters[10 + (1:3)],nobs,replace=TRUE)) 
mydat$x <- seq(0,1,length.out=nobs) + 0.33 * mydat$grp
mydat$y <- 0.25 * rnorm(nobs) + 2 * mydat$grp
mydat$grp <- factor(mydat$grp)
mydat$se  <- sqrt(mydat$x)

ggplot(mydat,aes(x=x,y=y,ymin=y-se,ymax=y+se,color=grp)) +
facet_grid(rowfac ~ colfac) + 
geom_line() + 
geom_errorbar() + 
labs(title='uncertainty by errorbar')

ggplot(mydat,aes(x=x,y=y,ymin=y-se,ymax=y+se,fill=grp)) +
facet_grid(rowfac ~ colfac) + 
geom_line() + 
geom_cloud(steps=15,max_alpha=0.85) +
labs(title='uncertainty by cloudr')
}
\seealso{
\code{\link[ggplot2]{geom_ribbon}}: The underlying geom
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{internal}
\keyword{plotting}
