% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoNodeUtils.R
\docType{class}
\name{GeoNodeUtils}
\alias{GeoNodeUtils}
\title{GeoNode REST API Manager Utils}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with static util methods for communication
with the REST API of a GeoNode instance.
}
\description{
GeoNode REST API Manager Utils

GeoNode REST API Manager Utils
}
\section{Static methods}{

\describe{
 \item{\code{getUserAgent()}}{
   This method is used to get the user agent for performing GeoNode API requests.
   Here the user agent will be compound by geonode4R package name and version.
 }
 \item{\code{getUserToken(user, pwd)}}{
   This method is used to get the user authentication token for performing GeoNode
   API requests. Token is given a Base64 encoded string.
 }
 \item{\code{GET(url, user, pwd, path, verbose)}}{
   This method performs a GET request for a given \code{path} to GeoNode REST API
 }
 \item{\code{PUT(url, user, pwd, path, filename, contentType, verbose)}}{
   This method performs a PUT request for a given \code{path} to GeoNode REST API,
   to upload a file of name \code{filename} with given \code{contentType}
 }
 \item{\code{POST(url, user, pwd, path, content, contentType, verbose)}}{
   This method performs a POST request for a given \code{path} to GeoNode REST API,
   to post content of given \code{contentType}
 }
 \item{\code{DELETE(url, user, pwd, path, verbose)}}{
   This method performs a DELETE request for a given GeoServer resource identified
   by a \code{path} in GeoNode REST API
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonode}
\keyword{rest}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GeoNodeUtils-clone}{\code{GeoNodeUtils$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GeoNodeUtils-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GeoNodeUtils-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeoNodeUtils$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
